Compute_Estimator_PESL_new = function(alpha, beta, x_np1){

log_f_G = function(x){
log(x) * dgamma(x, shape = alpha + 1, scale = 1)
}

Int = integrate(f = log_f_G, lower = 0, upper = 1 / (beta * x_np1)); Int

P_s_x = gamma_inc_P(a = alpha + 1, x = 1 / (beta * x_np1)); P_s_x
numerator = -log(beta) * P_s_x - Int$value; numerator ## <0 and >0 are both possible
denominator = pgamma(1/x_np1, shape = alpha + 1, scale = beta); denominator
log_denominator = pgamma(1/x_np1, shape = alpha + 1, scale = beta, log.p = TRUE); log_denominator

log_p1 = pgamma(1/x_np1, shape = alpha,     scale = beta, log.p = TRUE); log_p1
log_p2 = pgamma(1/x_np1, shape = alpha + 1, scale = beta, log.p = TRUE); log_p2
log_p3 = pgamma(1/x_np1, shape = alpha + 2, scale = beta, log.p = TRUE); log_p3

E1 = 1 / (alpha * beta) * exp(log_p1 - log_p2); E1
E2 = (alpha + 1) * beta * exp(log_p3 - log_p2); E2
E3 = sign(numerator) * exp(log(abs(numerator)) - log_denominator); E3

delta_s = 1 / E2
delta_2 = E1
PESL_s = log(E2) + E3
PESL_2 = E1 * E2 - 1 - log(E1) + E3

res = list(
delta_s = delta_s, 
delta_2 = delta_2, 
PESL_s = PESL_s,
PESL_2 = PESL_2
)
}

Int_value = function(a, b){
log_f_G = function(x){
log(x) * dgamma(x, shape = a + 1, scale = 1)
}

Int = integrate(f = log_f_G, lower = 0, upper = 1 / (b * x_np1))
res = Int$value
}

P_s_x = function(a, b){ gamma_inc_P(a = (a + 1), x = 1 / (b * x_np1)) }
numerator = function(a, b){ -log(b) * P_s_x(a, b) - Int_value(a, b) } ## +, -, and 0 are all possible

denominator = function(a, b){ pgamma(1/x_np1, shape = a + 1, scale = b) }
log_denominator = function(a, b){ pgamma(1/x_np1, shape = a + 1, scale = b, log.p = TRUE) }

log_p1 = function(a, b){ pgamma(1/x_np1, shape = a,     scale = b, log.p = TRUE) }
log_p2 = function(a, b){ pgamma(1/x_np1, shape = a + 1, scale = b, log.p = TRUE) }
log_p3 = function(a, b){ pgamma(1/x_np1, shape = a + 2, scale = b, log.p = TRUE) }

E1 = function(a, b){ 1 / (a * b) * exp(log_p1(a, b) - log_p2(a, b)) }
E2 = function(a, b){ (a + 1) * b * exp(log_p3(a, b) - log_p2(a, b)) }
E3 = function(a, b){ sign(numerator(a, b)) * exp(log(abs(numerator(a, b))) - log_denominator(a, b)) }

delta_s = function(a, b){ 1 / E2(a, b) }
delta_2 = function(a, b){ E1(a, b) }
PESL_s = function(a, b){ log(E2(a, b)) + E3(a, b) }
PESL_2 = function(a, b){ E1(a, b) * E2(a, b) - 1 - log(E1(a, b)) + E3(a, b) }

delta_2_s = function(a, b){ delta_2(a, b) - delta_s(a, b) }
PESL_2_s = function(a, b){ PESL_2(a, b) - PESL_s(a, b) }

Moment_estimators = function(x){
n = length(x)
A1 = mean(x)
M2 = (n - 1) / n * var(x)

alpha_1 = 2 * (3 * M2 + A1^2) / (3 * M2 - A1^2)
beta_1 = (3 * M2 - A1^2) / (6 * A1 * (M2 + A1^2))

res = c(alpha_1, beta_1)
}

Marginal_density_alpha_beta = function(x, alpha, beta){
## gamma_inc_Q() requires library(gsl)
F_IG_x = gamma_inc_Q(a = (alpha + 1), x = 1 / (beta * x))
res = alpha * beta * (1 - F_IG_x)
}

p_U_IG_alpha_Beta = function(x, alpha, Beta){

Marginal_density = function(x){
## gamma_inc_Q() requires library(gsl)
F_IG_x = gamma_inc_Q(a = (alpha + 1), x = 1 / (Beta * x))
res = alpha * Beta * (1 - F_IG_x)
}

L_x = length(x)
I_value = I_abs_error = numeric(L_x)
for (i in 1:L_x){
	I_i = integrate(f = Marginal_density, lower = 0, upper = x[i])
	I_value[i] = I_i$value
	I_abs_error[i] = I_i$abs.error
}

res = I_value
}

Compute_Proportions_vector_pmin = function(v1, v2, v3){
min_v = pmin(v1, v2, v3)
Proportions = numeric(3)
Proportions[1] = mean(v1 == min_v) 
Proportions[2] = mean(v2 == min_v) 
# Proportions[3] = mean(v3 == min_v) 
Proportions[3] = 1 - Proportions[1] - Proportions[2] # to avoid several minimums

res = Proportions
}

Compute_Proportions_vector_pmax = function(v1, v2, v3){
max_v = pmax(v1, v2, v3)
Proportions = numeric(3)
Proportions[1] = mean(v1 == max_v) 
Proportions[2] = mean(v2 == max_v) 
# Proportions[3] = mean(v3 == max_v) 
Proportions[3] = 1 - Proportions[1] - Proportions[2] # to avoid several maximums

res = Proportions
}


string_k = function(k){
if     (k < 10)
	s = paste("0", as.character(k), sep = "")
else 
	s = as.character(k)
}


Generate_Matrix_Latex = function(A){
m = nrow(A)
n = ncol(A)

C = rep("c", n, sep=""); C
temp = "[c]{"
for (i in 1:n){
temp = paste(temp, C[i], sep="")
}
temp = paste(temp, "}", sep="")

B = matrix("0", nrow = m, ncol = 2*n); B
for (i in 1:m){
	for (j in 1:n){
		B[i, 2*j-1] = A[i, j]
		B[i, 2*j]   = "&"
	}
}
B[, 2*n] = "\\\\"
B[m, 2*n] = ""
B

One = "\\begin{tabular}"
Two = temp
Three = B
Four = "\\end{tabular}"

cat(One, "\n", Two, "\n"); for (i in 1:m) cat(B[i, ], "\n");  cat(Four, "\n")
}

plot_estimator = function(delta_s, delta_2, parameter, para_name, xlab, legend_pos = "topleft", sub){
dev.new()
col = c("blue", "red")
lty = 1:2
xlim = range(parameter)
ylim = range(delta_s, delta_2)
#ylim=c(0:1)
plot(parameter, delta_s, type = "n", xlim = xlim, ylim = ylim, xlab = xlab, ylab = "Estimator", sub = sub)
lines(parameter, delta_s, lty = lty[1], col = col[1], lwd = 4)
lines(parameter, delta_2, lty = lty[2], col = col[2], lwd = 4)
leg.txt = c("delta_s", "delta_2")
legend(x = legend_pos, legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/U-IG_Estimator_", para_name, "_change", sep = ""), type = c("pdf"))
savePlot(filename = paste("figure/U-IG_Estimator_", para_name, "_change", sep = ""), type = c("jpg"))
}

plot_PESL = function(PESL_s, PESL_2, parameter, para_name, xlab, legend_pos = "topleft", sub){
dev.new()
col = c("blue", "red")
lty = 1:2
xlim = range(parameter)
ylim = range(PESL_s, PESL_2)
plot(parameter, PESL_s, type = "n", xlim = xlim, ylim = ylim, xlab = xlab, ylab = "PESL", sub = sub)
lines(parameter, PESL_s, lty = lty[1], col = col[1], lwd = 4)
lines(parameter, PESL_2, lty = lty[2], col = col[2], lwd = 4)
leg.txt = c("PESL_s", "PESL_2")
legend(x = legend_pos, legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/U-IG_PESL_", para_name, "_change", sep = ""), type = c("pdf"))
savePlot(filename = paste("figure/U-IG_PESL_", para_name, "_change", sep = ""), type = c("jpg"))
}

